#!/bin/sh
#
# Copyright (C) 1998, Mike Butler, mgb@mitre.org
#    
# This file is part of picptk, a PIC programmer for Linux
#
# Picptk is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# Picptk is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picptk; see the file COPYING.  If not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# $Id: picptk.tcl,v 1.2 1998/12/31 01:40:33 mgb Exp $
#
# the next line restarts using wish \
exec picp-wish "$0" "$@"

# This is the Gui for a  

proc AddItem { menu button } {
    set typ [lrange $button 0 0]
    set lbl [lrange $button 1 1]
    set arg [lrange $button 2 2]
    switch $typ {
	"command" { $menu add command -label "$lbl" -command $arg}
	"check"   { 
	    global $arg
	    $menu add checkbutton -label "$lbl" -variable $arg
	}
	"radio"   { 
	    global $arg
	    $menu add radiobutton -label "$lbl" -variable $arg -value $lbl \
		    -command "DoUpdate $arg"
	}
    }
}

proc MakeMenu { frame side title commands } {
    set name [string tolower $title]
    set menuname $frame.$name.menu
    menubutton $frame.$name -text $title -menu $menuname
    menu $menuname -tearoff false
    pack $frame.$name -side $side
    foreach i $commands {
	AddItem $menuname $i
    }
}

proc MenuFrame {} {
    frame .mbar -relief raised -bd 2
    pack .mbar -side top -fill x
    
    MakeMenu .mbar left "File" {
	{command "Load..." DoLoad} 
	{command "Save..." DoNoOp} 
	{command "Exit" exit}
    }
    
    MakeMenu .mbar left "Edit" {
	{command "Preferences..." DoNoOp} 
	{command "Segments..." DoNoOp} 
	{command "Chips..." DoNoOp} 
    }
    
    MakeMenu .mbar left "Port" {
	{radio "LPT0" port}
	{radio "LPT1" port}
	{radio "LPT2" port}
    }
    
    MakeMenu .mbar right "Help" {
	{command "About" DoAbout}
    }
}


# Procedures executed by buttons, etc...
proc DoNoOp   {} {Display "Sorry, not implemented..."}

proc DoAbout  {} {
    Display {
Description: Generic PIC programmer, extensible for various
             PIC families, programmer types, and user interfaces.
             Core routines are C++, this Gui is written in Tcl/Tk.
     Author: Mike Butler (mgb@mitre.org)
  Copyright: The MITRE Corporation, Bedford, MA 01730
       Date: November 1998
    } clear
}

# Verify PIC memory image 
proc DoVerify {} { Display [pic verify] clear }
# Dump entire PIC memory image 
proc DoDump   {} { Display [pic dump] clear }

# read contents of pic into ram
proc DoRead   {} { Display [pic read] clear }

# read contents of pic into ram
proc DoErase   {} { Display [pic erase] clear }

# Burn ram image into pic...
proc DoBurn   {} { Display [pic burn] clear }

# Load file into ram...
proc DoLoad   {} {
    global filename
    Display [pic load $filename] clear
}


# Some variable changed, do requisite update...
proc DoUpdate {var} {
    global $var
    switch $var {
	"port" { Display [pic port [set $var]] clear }
    }
}

# User chose a specific PIC device, let code know...
proc DoChoose {chip}  {
    pic chip $chip
    .chip.device config -text $chip
    Display [pic info] clear
}

# Print some text in status window
proc Display {text args}  {
    foreach i $args {
	switch $i {
	    "clear" { .status.text delete 1.0 end }
	}
    }
    
    .status.text insert end $text
    .status.text insert end "\n"
}


proc ChipFrame {} {
    frame .chip
    label .chip.label -text "Device:" -width 8 -anchor e
    menubutton .chip.device -text "(none)" -relief sunken -menu .chip.device.menu
    menu .chip.device.menu -tearoff false
    
    foreach chip [pic chips] {
	.chip.device.menu add command -label $chip -command [list DoChoose $chip]
    }
    pack .chip.label -side left
    pack .chip.device -anchor w -side left
    pack .chip -anchor w -fill x -pady 2 -padx 10
}

proc FileFrame {} {
    global filename
    frame .file
    label .file.label -text "File:" -width 8 -anchor e
    entry .file.filename -width 20 -relief sunken -bd 2 -textvariable filename
    pack .file.label -side left -anchor w
    pack .file.filename -anchor w -fill x

    pack .file -anchor w -fill x -pady 2 -padx 10
}

proc StatusFrame {} {
    frame .status -height 100 -width 100 -relief groove -bd 4
    scrollbar .status.scroll -command ".status.text yview"
    text .status.text -relief sunken -bd 4 -yscrollcommand ".status.scroll set"
    pack .status.text -side left
    pack .status.scroll -side right -fill y
    pack .status
}

proc CommandFrame {} {
    frame .cmd
    button .cmd.read -text "Read"   -command DoRead
    button .cmd.show -text "Show"   -command DoDump
    button .cmd.load -text "Load"   -command DoLoad
    button .cmd.burn -text "Burn"   -command DoBurn
    button .cmd.vrfy -text "Verify" -command DoVerify
    button .cmd.eras -text "Erase"  -command DoErase
    pack  .cmd.read .cmd.show .cmd.load .cmd.burn .cmd.vrfy .cmd.eras -side left
    pack .cmd -side bottom
}

Pic pic

MenuFrame
ChipFrame
FileFrame
StatusFrame
CommandFrame

Display "

    **************** Notice ****************

    You are using the Tk user interface to
    picp.  This interface is NOT supported
    and will disappear in the next release.
    It has been superceeded by an improved
    user interface implemented in incrTk.
    Please install inctTcl/incrTk on your
    system and rebuild picptk.  (Besides, the
    new interface is significantly better
    than this...)"  clear 
