/* Copyright (C) 1998, Mike Butler, mgb@mitre.org
 *    
 * This file is part of picptk, a PIC programmer for Linux
 *
 * Picptk is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * Picptk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with picptk; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: UiItk.h,v 1.3 1998/12/31 01:40:33 mgb Exp $
 *
 * Example of hooking up C++ object to TCL...
 * Four (static) commands are necessary,
 *
 * TclInit() Registers an object creation command
 * TclNew()  creates a new object and binds it to a new command
 * TclExec() calls the invokes an object to execute a method
 * TclKill() Deletes a specific object instance
 */

// Even though the interface may be incrTk, 
// <tk.h> contains what we need here...
#include <tk.h>
#include <PicCore.h>

class Gui {
private:
  Pic cPic;			// What we control...

  typedef struct {
    const char *cName;		// command name
    Tcl_CmdProc *cProc;		// handler proc
    int cArgs;			// number of args (after command)
    const char *cPrintName;	// What the user calls it...
  } HandlerBinding_t;

  static HandlerBinding_t cHandlers[];

  // Bindings that TCL calls more or less directly
  static int TclInit(Tcl_Interp *interp, char *cmd = "Pic");
  static int TclNew(ClientData, Tcl_Interp *, int argc, char *argv[]);
  static int TclExec(ClientData, Tcl_Interp *, int argc, char *argv[]);
  static void TclDestroy(ClientData);

  // Call handlers (dispached by TclExec)
  static int DoLoad(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoRead(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoVerify(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoBurn(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoChips(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoPins(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoInfo(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoVersion(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoChip(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoPort(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoDump(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoErase(Gui *, Tcl_Interp *, int argc, char *argv[]);
  static int DoSet(Gui *me, Tcl_Interp *interp, int argc, char *argv[]);
  static int DoGet(Gui *me, Tcl_Interp *interp, int argc, char *argv[]);
  static int DoSavePrefs(Gui *me, Tcl_Interp *interp, int argc, char *argv[]);
  static int DoLoadPrefs(Gui *me, Tcl_Interp *interp, int argc, char *argv[]);

  // Procedure to collect error reports...
  static bool CollectErrors(void *interp, const char *seg, uint size,
			    uint addr, uint want, uint got);
  
public:
  static int AppInit(Tcl_Interp *interp);
};
