/* Copyright (C) 1998, Mike Butler, mgb@mitre.org
 *    
 * This file is part of picptk, a PIC programmer for Linux
 *
 * Picptk is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * Picptk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with picptk; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * $Id: PicSerial.h,v 1.2 1998/12/31 01:40:33 mgb Exp $
 * 
 * Driver for a serial port programmer...
 * This class "glues" the pic core (which thinks in terms of PIC pins)
 * to a specific programmer which is controlled in terms of I/O port 
 * pins.
 */
#ifndef _PicSerial_h_
#define _PicSerial_h_

#include <PicDriver.h>
/* Serial port programmer...
 */
class SerialDriver : public Driver {
protected:
  struct termios cState;
  int cPort;
  virtual void SetPin(Pic::Pin_t pin, int val = 1);
  virtual bool GetPin(Pic::Pin_t pin);
public:
  SerialDriver(Environment &);
  ~SerialDriver();
  virtual const char **Pins();		// List of pins (for this programmer)
};

#endif // _PicSerial_h_
