/* Copyright (C) 1998, Mike Butler, mgb@mitre.org
 *    
 * This file is part of picptk, a PIC programmer for Linux
 *
 * Picptk is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * Picptk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with picptk; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: PicPersonality.C,v 1.2 1998/12/31 01:40:33 mgb Exp $
 *
 * These are configuration tables for specific PICs.
 *
 * ToDo:
 *    Place this information in a config file rather than in code...
 */
#include <PicCore.h>

 // Pic::cAllPics - Description of all supported Pic members
// Table of all pic types and their memory maps
// Memory sizes are all in words...
// Note that segments must appear in an order that allows all
// operations to be done in one power-on power-off cycle e.g.,
// This is due to an undocumented(?) timing of the C76 which requires 
// a full second between programming mode entries...
MMap Pic::cAllPics[] = {
  //{"PIC16C84", "PIC16F84"},	// A rose by any other name...
  {"PIC16F84", 0, {
    //     style            name      skip   length   base
    {Segment::flash_prog, "program", 0x0000, 0x0400, 0x0000, 14},
    {Segment::flash_conf,      "id", 0x0000, 0x0004, 0x2000, 14},
    {Segment::flash_conf,  "config", 0x0007, 0x0001, 0x2007, 14},
    {Segment::flash_data, "ee data", 0x0000, 0x0040, 0x2100,  8}, }},
  {"PIC16C76", 0, {
    //     style            name      skip   length   base
    {Segment::eprom_prog, "program", 0x0000, 0x2000, 0x0000, 14},
    {Segment::eprom_conf,      "id", 0x0000, 0x0004, 0x2000, 14},
    {Segment::eprom_conf,  "config", 0x0007, 0x0001, 0x2007, 14}, }},
  {"PIC12C5xx", 0, {
    //     style            name      skip   length   base
    {Segment::eprom_prog, "program", 0x0001, 0x0100, 0x0000, 12},
    {Segment::eprom_prog,      "id", 0x0100, 0x0004, 0x2000, 12},
    {Segment::eprom_prog,  "config", 0x0000, 0x0001, 0x2007, 12}, }},

  {0}				// must be last! (end sentinal)
};

