/* Copyright (C) 1998, Mike Butler, mgb@mitre.org
 *    
 * This file is part of picptk, a PIC programmer for Linux
 *
 * Picptk is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * Picptk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with picptk; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * $Id: PicParallel.h,v 1.2 1998/12/31 01:40:32 mgb Exp $
 * 
 * Driver for a parallel port programmer...
 * This class "glues" the pic core (which thinks in terms of PIC pins)
 * to a specific programmer which is controlled in terms of I/O port 
 * pins.
 */
#ifndef _PicParallel_h_
#define _PicParallel_h_

#include <PicDriver.h>
#include <IfParPort.h>

/* Parallel port programmer...
 * includes mappings for pins, etc...
 */
class ParallelDriver : public Driver {
protected:
  int cPinMap[Pic::pin_last];

  ParallelPort *cPort;

  // Stupidity for porgrammer, sometimes asserted is low, sometimes high!
  // Let that be captured in the pin number (-1 --> pin 1 asserted low)
  static struct PinTbl_t {
    Pic::Pin_t index;
    const char *name;
    const char *def;
  } cPinTbl[];


  virtual void SetPin(Pic::Pin_t pin, int val = 1);
  virtual bool GetPin(Pic::Pin_t pin);
public:
  ParallelDriver(Environment &env);
  virtual const char **Pins();
};

#endif // _PicParallel_h_
