/* Copyright (C) 1998, Mike Butler, mgb@mitre.org
 *    
 * This file is part of picptk, a PIC programmer for Linux
 *
 * Picptk is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * Picptk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with picptk; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * $Id: PicDriver.h,v 1.2 1998/12/31 01:40:32 mgb Exp $
 *
 * Abstract information about a specific PIC programmer...
 * Encapsulates details on getting data to and from programmer...
 * Also includes pin mapping and sense of asserted values...
 */
#ifndef _PicDriver_h_
#define _PicDriver_h_

#include <stdlib.h>		// for uint
#include <termios.h>		// for serial port support
#include <PicCore.h>

/* generic programmer...  Parallel, serial, other... */
class Driver {
protected:
  Environment &cEnv;
public:
  virtual void SetPin(Pic::Pin_t pin, int val = 1) = 0;
  virtual bool GetPin(Pic::Pin_t pin) = 0;

  Driver(Environment &env) : cEnv(env) {}
  virtual ~Driver() {}
  virtual const char **Pins() = 0;
};
#endif // _PicDriver_h_
