/* Copyright (C) 1998, Mike Butler, mgb@mitre.org
 *    
 * This file is part of picptk, a PIC programmer for Linux
 *
 * Picptk is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * Picptk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with picptk; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * $Id: IoIntel.h,v 1.2 1998/12/31 01:40:32 mgb Exp $
 *
 * Intel Hex format file I/O ...
 */

#ifndef IntelHex_h
#define IntelHex_h

#include <stdlib.h>		// for uint
#include <fstream.h>
#include <iostream.h>

// This probably should be more general and read multiple formats...
class IntelHex {
  typedef void (*CbSetByte)(void *v, uint addr, char val);
  typedef bool (*CbGetByte)(void *v, uint &addr, uint &next, char &val);
private:
  static int ParseLine(const char* line, CbSetByte cb, void *obj);
  static bool OutputLine(ostream &os, int len, uint addr = 0, char *buf = 0);
public:
  static int Load(istream &is, CbSetByte cb, void *obj);
  static bool Save(ostream &os, CbGetByte cb, void *obj);
};

#endif // IntelHex_h
