/* Copyright (C) 1998, Mike Butler, mgb@mitre.org
 *    
 * This file is part of picptk, a PIC programmer for Linux
 *
 * Picptk is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * Picptk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with picptk; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * $Id: IfParPort.h,v 1.2 1998/12/31 01:40:31 mgb Exp $
 */
/* Parallel port abstraction... 
 * Presently deals with port on a per-pin basis
 * In this implementation, data pins are unidirectional (out)
 * while some control pins are in and some out.
 * (This class should be extended to implement the "standard," EPP, 
 * and ECP formats)
 *
 * To gain access to the underlying hardware ports the code must be able
 * to setuid() long enough for the ioperm() call to succeed.
 */
#ifndef _ParPort_h_
#define _ParPort_h_

#include <stdlib.h>		// for uint
#include <UtEnvLite.h>

class ParallelPort {
private:
  enum { kMaxPorts = 3,
	 kPortSize = 3,
	 kMaxPins  = 25,
  };
  uint cPort;
  uint cState[kPortSize];	// in bytes...

  typedef enum { nc, in, out, } Dir_t;
  struct PinInfo_t {
    Dir_t dir;
    char sense;
    char offset;
    char mask;
  } cPinInfo[kMaxPins];


  // Gain access to parallel port, return 0 on success...
  bool Access(uint port, bool allow);
public:
  ParallelPort(uint port);
  ~ParallelPort();

  void SetPin(uint pin, bool val = 1);
  void ClrPin(uint pin) { SetPin(pin, 0); }
  bool GetPin(uint pin);
  void WriteByte(char data);
  char ReadByte();
};

#endif // _ParPort_h_
